
;;;======================================================
;;;   Gift Selection Expert System
;;;
;;;     This programm choose a suitable gift for a person
;;;    
;;;
;;;     CLIPS Version 6.0 Example
;;;
;;;     To execute, merely load, reset and run.
;;;======================================================


(deffunction ask-question (?question $?allowed-values)
   (printout t ?question)
   (bind ?answer (read))
   (if (lexemep ?answer) 
       then (bind ?answer (lowcase ?answer)))
   (while (not (member ?answer ?allowed-values)) do
      (printout t ?question)
      (bind ?answer (read))
      (if (lexemep ?answer) 
          then (bind ?answer (lowcase ?answer))))
   ?answer)

(deffunction yes-or-no-p (?question)
   (bind ?response (ask-question ?question yes no y n))
   (if (or (eq ?response yes) (eq ?response y))
       then TRUE 
       else FALSE))

;-----------------------

(defrule les "ask questions"
	(initial-fact)
	=>
	(bind ?music  (ask-question "Does he/she likes music (yes/no)? " yes no) )
	(assert (music ?music)) 
	(bind ?educated  (ask-question "Is he/she educated (yes/no)? " yes no) )
	(assert (educated ?educated)) 
	(bind ?expen  (ask-question "Do you want an expensive gift (yes/no)? " yes no) )
	(if (eq ?expen yes) 
		then (assert (price expensive)) )
	(printout t "How many years old is he/she? ")
	(bind ?age (read))
	(assert (age ?age))
)
			
(defrule cd "cd gift rule"
    (or (agegroup middle) (agegroup old))
    (music yes)
   =>
    (assert (gift CD)))

(defrule toy "toy gift rule"
   (agegroup child)
   (price expensive)
   =>
   (assert (gift toy)))

(defrule clothes "clothes gift rule"
   (agegroup middle)
   (price expensive)
   =>
   (assert (gift clothes)))
   
(defrule flowers "flowers gift rule"
   (agegroup old)
   (price expensive)
   =>
   (assert (gift flowers)))

(defrule book "book gift rule"
   (or (agegroup middle) (agegroup child))
   (educated yes)
   =>
   (assert (gift book)))

(defrule child "child age rule"
	(age ?x)
      	=>
	(if (< ?x 15) then
	(assert (agegroup child))))

(defrule middle "middle age rule"
   (age ?x)
   =>
   (if (and (> ?x 14) (< ?x 35)) then
   (assert (agegroup middle))))

(defrule old "old age rule"
   (age ?x)
   =>
   (if (> ?x 34) then
   	(assert (agegroup old))))

(defrule printresult "a rule to print out the results"
   (gift ?x)
   =>
   (printout t "A possible gift is " ?x crlf))

 